package gov.va.med.domain.model;

import java.io.Serializable;
import java.util.Set;

/**
 * @hibernate.class table="PATIENT_TREATMENT_LOCATIONS"
 */
public class HealthRecords extends gov.va.med.domain.model.DomainObject implements Serializable {

	
    /** persistent field */
	private Set copays;

    /** persistent field */
	private Set personalInformations;

	/**
	 * persistent field
	 */
	private Set healthReminders;

	/**
	 * persistent field
	 */
	private Set radiologyResults;

	/**
	 * persistent field
	 */
	private Set appointments;

	/**
	 * persistent field
	 */
	private Set microbiologyResults;

	/**
	 * persistent field
	 */
	private Set vitals;

	/**
	 * persistent field
	 */
	private Set problemLists;

	/**
	 * persistent field
	 */
	private Set cytologies;

	/**
	 * persistent field
	 */
	private Set chemistryHematologies;

	/**
	 * persistent field
	 */
	private Set immunizations;

	/**
	 * persistent field
	 */
	private Set microscopyResults;

	/**
	 * persistent field
	 */
	private Set admissions;

	/**
	 * persistent field
	 */
	private Set ecgs;

	/**
	 * persistent field
	 */
	private Set allergies;

	/**
	 * persistent field
	 */
	private Set pathologies;

	

    /**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.Copay"
	 */
	public Set getCopays() {
		return this.copays;
	}

	    public void setCopays(Set copays) {
	        this.copays = copays;
    }

   /**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.PersonalInformation"
	 */
    public Set getPersonalInformations() {
        return this.personalInformations;
    }

    public void setPersonalInformations(Set personalInformations) {
        this.personalInformations = personalInformations;
    }

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.HealthReminder"
	 */
	public Set getHealthReminders() {
		return this.healthReminders;
	}

	public void setHealthReminders(Set healthReminders) {
		this.healthReminders = healthReminders;
	}


	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.RadiologyResult"
	 */
	public Set getRadiologyResults() {
		return this.radiologyResults;
	}

	public void setRadiologyResults(Set radiologyResults) {
		this.radiologyResults = radiologyResults;
	}

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.Appointment"
	 */
	public Set getAppointments() {
		return this.appointments;
	}

	public void setAppointments(Set appointments) {
		this.appointments = appointments;
	}

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.MicrobiologyResult"
	 */
	public Set getMicrobiologyResults() {
		return this.microbiologyResults;
	}

	public void setMicrobiologyResults(Set microbiologyResults) {
		this.microbiologyResults = microbiologyResults;
	}

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.Vital"
	 */
	public Set getVitals() {
		return this.vitals;
	}

	public void setVitals(Set vitals) {
		this.vitals = vitals;
	}

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.ProblemList"
	 */
	public Set getProblemLists() {
		return this.problemLists;
	}

	public void setProblemLists(Set problemLists) {
		this.problemLists = problemLists;
	}

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.Cytology"
	 */
	public Set getCytologies() {
		return this.cytologies;
	}

	public void setCytologies(Set cytologies) {
		this.cytologies = cytologies;
	}

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.ChemistryHematology"
	 */
	public Set getChemistryHematologies() {
		return this.chemistryHematologies;
	}

	public void setChemistryHematologies(Set chemistryHematologies) {
		this.chemistryHematologies = chemistryHematologies;
	}

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.Immunizations"
	 */
	public Set getImmunizations() {
		return this.immunizations;
	}

	public void setImmunizations(Set immunizations) {
		this.immunizations = immunizations;
	}

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.MicroscopyResult"
	 */
	public Set getMicroscopyResults() {
		return this.microscopyResults;
	}

	public void setMicroscopyResults(Set microscopyResults) {
		this.microscopyResults = microscopyResults;
	}

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.Admission"
	 */
	public Set getAdmissions() {
		return this.admissions;
	}

	public void setAdmissions(Set admissions) {
		this.admissions = admissions;
	}

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.Ecg"
	 */
	public Set getEcgs() {
		return this.ecgs;
	}

	public void setEcgs(Set ecgs) {
		this.ecgs = ecgs;
	}

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.Allergy"
	 */
	public Set getAllergies() {
		return this.allergies;
	}

	public void setAllergies(Set allergies) {
		this.allergies = allergies;
	}

	/**
	 * @hibernate.set lazy="true" inverse="true" cascade="none"
	 * @hibernate.collection-key column="USER_ID_SEQ"
	 * @hibernate.collection-key column="ICN"
	 * @hibernate.collection-key column="INSTITUTION_ID"
	 * @hibernate.collection-one-to-many class="gov.va.med.domain.model.Pathology"
	 */
	public Set getPathologies() {
		return this.pathologies;
	}

	public void setPathologies(Set pathologies) {
		this.pathologies = pathologies;
	}

//	public String toString() {
//		return new ToStringBuilder(this).append("comp_id", getId()).append("currentInd", getCurrentInd()).append(
//		    "createdDate", getCreatedDate()).append("modifiedDate", getModifiedDate()).toString();
//	}
//
//	public boolean equals(Object other) {
//		if((this == other))
//			return true;
//		if(!(other instanceof HealthRecords))
//			return false;
//		HealthRecords castOther = (HealthRecords)other;
//		return new EqualsBuilder().append(this.getId(), castOther.getId()).append(this.getCreatedDate(),
//		                                                                          castOther.getCreatedDate()).append(
//		                                                                              this.getModifiedDate(),
//		                                                                              castOther.getModifiedDate())
//		    .isEquals();
//	}


	/**
	 * ************************************************************************
	 * PUT ANY CUSTOM CODE FOR THIS OBJECT BELOW THIS COMMENT IF YOU USE
	 * hbm2java, IT WILL OVERWRITE THIS ENTIRE OBJECT SO BEWARE CAUSE THIS
	 * CUSTOM CODE WILL BE LOST
	 */

	public HealthRecords(){
	}

	
	/**
	 * Initialize with key values dervied from Patient and station number.
	 * @param stationNumber
	 */
//	private void initializeFromStationNumber(String stationNumber) {
//	    Institution institution =
//	        InstitutionStationNumberMapper.getInstitutionByStationNumber(
//	                				stationNumber);
//
//	    setInstitutionName(institution.getVistaName());
//	    HealthRecordsPK key = new HealthRecordsPK();
//	    key.setInstitutionId(institution.getId());
//	    key.setIcn(getPatient().getIcn());
//	    if (getPatient().getUserid() != null) 
//        {
//	        key.setUserId(new Long(getPatient().getUserid()));
//	    }
//	    setId(key);
//    }
}
